<?php
class ControladorCobros{

	/*=============================================
	MOSTRAR CONTRATOS
	=============================================*/

	static public function ctrMostrarCobros($item, $valor){

		$tabla = "cobros";

		$respuesta = ModeloCobros::mdlMostrarCobros($tabla, $item, $valor);

		return $respuesta;

	}

	/*=============================================
	MOSTRAR CONTRATOS
	=============================================*/

	static public function ctrMostrarCobrosSerieA($item, $valor){

		$tabla = "cobros";

		$respuesta = ModeloCobros::mdlMostrarCobrosSerieA($tabla, $item, $valor);

		return $respuesta;

	}


	static public function ctrMostrarCronograma($item, $valor){

		$tabla = "detalle_servicio";

		$respuesta = ModeloCobros::mdlMostrarCronograma($tabla, $item, $valor);


		return $respuesta;

	}

	static public function ctrMostrarCobrosReporte($item, $valor){

		$tabla = "editar_cobro";

		$respuesta = ModeloCobros::mdlMostrarCobrosReporte($tabla, $item, $valor);

		return $respuesta;

	}

	static public function ctrMostrarCronogramaPago($item, $valor){

		$tabla = "detalle_servicio";

		$respuesta = ModeloCobros::mdlMostrarCronogramaPago($tabla, $item, $valor);


		return $respuesta;

	}


	static public function ctrEliminarCobro($valor){

		$tabla0 = "cronograma_pago";
		$tabla1 = "cobros";
		$tabla2 = "detalle_cobros";

		$respuesta4 = "";

		$respuesta = ModeloCobros::mdlObtenercronograma($tabla2,$valor);

		if ($respuesta != null){
			foreach ($respuesta as $value) {
				$respuesta2 = ModeloCobros::mdlActualizarCrono($tabla0,$value["idcronograma_pago"]);
			}
			$respuesta3 = ModeloCobros::mdlEliminarCobros($tabla2, $valor);
			if($respuesta3 == "ok"){
				$respuesta4 = ModeloCobros::mdlEliminarCobros($tabla1, $valor);
			}


		}


		return $respuesta4;

	}

	static public function ctrEditarCobro($item,$valor){

		$tabla = "editar_cobro";

		$respuesta = ModeloCobros::mdlEditarCobro($tabla,$item, $valor);


		return $respuesta;

	}

	static public function ctrUltimoPago($valor){

		$tabla = "cronograma_pago";

		$respuesta = ModeloCobros::mdlUltimoPago($tabla,$valor);


		return $respuesta;

	}

	static public function ctrMesesFlatantes($valor){

		$respuesta = ModeloCobros::mdlMesesFlatantes($valor);


		return $respuesta;

	}


	/* Este codigo es para mostrar todo desde vista de la base de datos */

	static public function ctrMostrarContratosCompleta($item, $valor){

		$tabla = "servicios_completo";

		$respuesta = ModeloContratos::mdlMostrarContratosCompleta($tabla, $item, $valor);

		return $respuesta;

	}


	/*=============================================
	CREAR CONTRATOS
	=============================================*/

	static public function ctrGuardarPagos($cadena){
		//$data = json_decode($cadena);

		$res2 = "";
		$res3 = "";
		$tabla = "cobros";
		/*
		1°  idcronograma_pago(0), servicio(1), conceptoPago(2), mes(3), subtotal(4), subtotal(5), X(6), recargo(7), descripcion(8), idservicio(9).
		luego con la funcion append recorro nuevamente el array y agrego nuevos campos que son:
		2°  idpersona(10), idusuario(20), idservicio(12), fecha(13), idcronograma_pago(14), totalMonto(15), CodigoA(16), CodigoR(17), codigoContrato(18), idCaja(19) 
		*/


		$datos = array("codigo"=>$cadena[0][1],
					  "codigoA"=>$cadena[0][16],
					   "codigoR"=>$cadena[0][17],
					   "mpago"=>$cadena[0][21],
					   "notitas"=>$cadena[0][22],
					   "banco"=>$cadena[0][23],
			           "idusuario"=>$cadena[0][11],
			           "idpersona"=>$cadena[0][10],
			           "idservicios"=>$cadena[0][12],
			           "subtotal"=>$cadena[0][15],
			       		"total"=>$cadena[0][15],
			       		"fechacobro"=>$cadena[0][13],
			       		"recargo"=>$cadena[0][7],
						"tipo" => $cadena[0][20],
						"mpago"=>$cadena[0][21],
                        "notitas"=>$cadena[0][22],
                        "banco"=>$cadena[0][23]
					);

		$respuesta = ModeloCobros::mdlIngresarCobros($tabla, $datos);
		$totalComercial = 0;
		$totalDomiciliario = 0;
		$arrayDescripcion = array();
		$arrayIdServicio = array();
		if($respuesta != "error"){

			foreach ($cadena as $key => $value) {
				if($value[0] != null){
					$descripcion = $cadena[$key][8];

					if(!in_array($descripcion, $arrayDescripcion)){
						//echo "<script>alert('".$descripcion."')</script>";
						array_push($arrayDescripcion, $descripcion);
					}
					//$subTotal = number_format(substr($cadena[$key][4], 2),2,'.','');
					$subTotal = str_replace(',','',$cadena[$key][4]);

					if($descripcion == "Domiciliar"){
						$totalDomiciliario += $subTotal;
					}
					else if ($descripcion == "Comercio"){
						$totalComercial += $subTotal;
					}

					/* if para agregar id de servicio en un array sin que se repitan
					para porteriormente recorrerlo y realizar una consulta que consiste en saber si el servicio contiene mas pagos.
					*/
					$idServicio = $cadena[$key][9];
					if(!in_array($descripcion, $arrayIdServicio)){
						//echo "<script>alert('".$descripcion."')</script>";
						array_push($arrayIdServicio, $idServicio);
					}

					$ntabla = "detalle_cobros";

					$datos2 = array("idcobro"=>$respuesta,"idcronograma_pago"=>$value[0]);

					$res = ModeloCobros::mdlIngresarDetalleCobros($ntabla, $datos2);

					if($res == "ok"){
						$ntabla1 = "cronograma_pago";
						$ntabla2 = "servicios";
						$res2 = ModeloCobros::mdlActualizarCronograma($ntabla1, $value[0]);

						if($cadena[0][7] == 1){
							$res3 = ModeloCobros::mdlActualizarServicioR($ntabla2, $value[12]);
						}else{
							$res3 = ModeloCobros::mdlActualizarServicio($ntabla2, $value[12]);
						}



					}

				}

			}

			/* Datos que necesito para guardar el detalle de la caja ********
		id, idCaja, fecha, tipoCaja(cobranza), concepto(comercial, domiciliaria), numeroDocumento(código del contrato), importeCaja(valor pagado), tipoPago(efectivo), generadoPor(nombre del usuario activo), estado caja (pagado)*/
		if(is_array($arrayDescripcion) && !empty($arrayDescripcion)){
			foreach($arrayDescripcion as $datosDetalle){
				if($datosDetalle == "Comercio"){
					$datos = array(
						"idCaja"=>$cadena[0][19],
						"fechacobro"=>$cadena[0][13],
						"tipoCaja"=>$cadena[0][8],
						"concepto"=>$cadena[0][2],
						"numeroDocumento"=>$cadena[0][16],
						"total"=>$totalComercial,
						"tipoPago"=>"Efectivo",
						"idusuario"=>$cadena[0][11],
						"estadoCaja"=>"Pagado"
					);
					$res4 = ModeloCobros::mdlIngresarDetalleCaja("detallecaja", $datos);
				}
				else if($datosDetalle == "Domiciliar"){
					$datos = array(
						"idCaja"=>$cadena[0][19],
						"fechacobro"=>$cadena[0][13],
						"tipoCaja"=>$cadena[0][8],
						"concepto"=>$cadena[0][2],
						"numeroDocumento"=>$cadena[0][16],
						"total"=>$totalDomiciliario,
						"tipoPago"=>"Efectivo",
						"idusuario"=>$cadena[0][11],
						"estadoCaja"=>"Pagado"
					);
					$res4 = ModeloCobros::mdlIngresarDetalleCaja("detallecaja", $datos);
				}

			}
		}

		if(is_array($arrayIdServicio) && !empty($arrayIdServicio)){
			foreach($arrayIdServicio as $idServicio_){
				$estado = ModeloCobros::mdlObtenerCobrosFaltantes($idServicio_);

				if($estado != null){
					if ($estado["conteo"] == 0) {
						$estado2 = ModeloCobros::mdlFinalizarServicio($idServicio_);
					}
				}
			}

		}


		}

		if($res2 == "ok" && $res3 == "ok" && $res4 == "ok"){
			return "ok";
		}



	}


	/*=============================================
	RANGO FECHAS
	=============================================*/

	static public function ctrRangoFechasContratos($fechaInicial, $fechaFinal){

		$tabla = "servicios";

		$respuesta = ModeloContratos::mdlFechasContratos($tabla, $fechaInicial, $fechaFinal);

		return $respuesta;

	}



	/*=============================================
	EDITAR CONTRATOS
	=============================================*/

	static public function ctrEditarContratos(){

		if(isset($_POST["nuevoNombreCliente"])){

			if(preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoNombreCliente"]) &&
			   preg_match('/^[a-zA-Z0-9ñÑáéíóúÁÉÍÓÚ ]+$/', $_POST["nuevoTipoServicio"])){

			   	$tabla = "servicios";

			   	$datos = array("idservicios"=>$_POST["idservicios"],
			   				   "codigo"=>$_POST["nuevoCodigo"],
					           "idusuario"=>$_POST["IdUsuario"],
					           "idpersona"=>$_POST["idpersona"],
					           "numromeses"=>$_POST["nuevoMeses"],
					           "idtipo_servicios"=>$_POST["idtipo_servicios"]);

			   	$respuesta = ModeloContratos::mdlEditarContratos($tabla, $datos);

			   	if($respuesta == "ok"){

					echo'<script>

					swal({
						  type: "success",
						  title: "El contrato de servicio ha sido actualizado correctamente",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
									if (result.value) {

									window.location = "personas";

									}
								})

					</script>';

				}

			}else{

				echo'<script>

					swal({
						  type: "error",
						  title: "¡El contrato de servicio no puede ir vacío o llevar caracteres especiales!",
						  showConfirmButton: true,
						  confirmButtonText: "Cerrar"
						  }).then(function(result){
							if (result.value) {

							window.location = "personas";

							}
						})

			  	</script>';



			}

		}

	}


	/*=============================================
	ELIMINAR CONTRATOS
	=============================================*/

	static public function ctrEliminarContrato(){

		if(isset($_GET["idservicios"])){

			$tabla ="servicios";
			$datos = $_GET["idservicios"];

			$respuesta = ModeloContratos::mdlEliminarContrato($tabla, $datos);

			if($respuesta == "ok"){

				echo'<script>

				swal({
					  type: "success",
					  title: "El cliente ha sido borrado correctamente",
					  showConfirmButton: true,
					  confirmButtonText: "Cerrar",
					  closeOnConfirm: false
					  }).then(function(result){
								if (result.value) {

								window.location = "personas";

								}
							})

				</script>';

			}

		}

	}







}
